#pragma rtGlobals=1		// Use modern global access method.


Macro Macro2i(particle1,particle2, xg,yg,tp0,t0,K2,K0, Kt0, kt2)
	variable xg =0
	variable yg= 0
	variable tp0 = 1006
	variable t0 = 603
	variable K0=0.02
	variable K2= 5000
	variable Kt0=-55
	variable Kt2= 2.8
	String particle1="i1"	
	String particle2="i2"
	Prompt particle1, "1rst particle label"
	Prompt particle2, "2nd particle label"
	Prompt xg, "X center"
	Prompt yg, "Y center"
	Prompt tp0, "Measured TOF"
	Prompt t0, "Real TOF (ns)"
	Prompt K2 "Transverse Magnification (0 order)"
	Prompt K0, "Transverse Magnification (1 order)"
	Prompt Kt0, "Longitudinal Constant (0 order)"
	Prompt Kt2 "Longitudinal Constant (1 order)"

	macro2i_lens(particle1,particle2, xg,yg,tp0,t0,K0,K2,kt0, Kt2)
End


//-------------------------------------------------------------------------------------------------------------------------------------------------------------       
//												2 IONS
//-------------------------------------------------------------------------------------------------------------------------------------------------------------    


function macro2i_Lens(particle1, particle2, xg,yg,tp0,t0,K0,K2,Kt,Kt2)
	String particle1, particle2
	variable xg, yg, tp0, t0,K0,K2,Kt,Kt2
	variable NbPoints,kk=0, delta, xx,yy,tt
	variable tau=tp0/2+t0
	WAVE x_i1=x_i1,y_i1=y_i1, t_i1=t_i1
	WAVE x_i2=x_i2,y_i2=y_i2, t_i2=t_i2

	duplicate/o x_i1 px_i1,py_i1,pz_i1
	duplicate/o x_i1 px_i2,py_i2,pz_i2
       variable au=0.6*10*sqrt(10) 
	NbPoints=numpnts(x_i1)
	for (kk=0; kk<Nbpoints; kk+=1)
		// x and y momenta of ions (Physically the first detected ion is labelled t_i2,x_i2,y_i2 in Common Stop mode of the TDC)
		xx=(x_i1[kk]-xg)*au
		yy=(y_i1[kk]-yg)*au
		tt=-t_i1[kk]/2+tau
		px_i1[kk]=xx*sqrt(K2/tt^2+K0)   // without lens K0=0
		py_i1[kk]=yy*sqrt(K2/tt^2+K0)  
		
		xx=(x_i2[kk]-xg)*au
		yy=(y_i2[kk]-yg)*au
		tt=-t_i2[kk]/2+tau		
		px_i2[kk]=xx*sqrt(K2/tt^2+K0)		
		py_i2[kk]=yy*sqrt(K2/tt^2+K0)
		// z momenta at the second order (linear approx. not good enough)
		delta=(Kt)^2+4*(tp0-t_i1[kk])/2*Kt2
		pz_i1[kk]= (-Kt-sqrt(delta))/(2*Kt2)*au/0.6
		delta=(Kt)^2+4*(tp0-t_i2[kk])/2*Kt2
		pz_i2[kk]= (-Kt-sqrt(delta))/(2*Kt2)*au/0.6
	endfor
	
	Silent 1;
	Execute ("Histo_Momenta(\""+particle1+"\",\"\",-200,200,50, 30)")
	Execute ("Histo_Momenta(\""+particle2+"\",\"\",-200,200,50, 30)")
	// Calcul Energy-Angle
	Execute ("AngleEnergy(\""+particle1+"\")")
	Execute ("AngleEnergy(\""+particle2+"\")")
	Execute ("Correlation(\""+particle1+"\",\""+particle2+"\")")
	
end
       